<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

require_once 'db.php';

$response = ['success' => false, 'message' => ''];

try {
    // Get JSON input
    $json = file_get_contents('php://input');
    $input = json_decode($json, true);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception('Invalid JSON format');
    }
    
    // Validate input
    if (empty($input['category'])) {
        throw new Exception('Category is required');
    }
    if (!isset($input['status'])) {
        throw new Exception('Status is required');
    }

    // Sanitize input
    $id = isset($input['id']) ? intval($input['id']) : null;
    $category = $conn->real_escape_string(trim($input['category']));
    $status = $conn->real_escape_string($input['status']);
    
    if ($id) {
        // Update existing record
        $sql = "UPDATE blog_category SET category='$category', status='$status' WHERE Blog_category_id='$id'";
        $action = 'updated';
    } else {
        // Insert new record
        $sql = "INSERT INTO blog_category (category, status) VALUES ('$category', '$status')";
        $action = 'added';
    }
    
    if ($conn->query($sql)) {
        $response = [
            'success' => true,
            'message' => 'Category ' . $action . ' successfully',
            'id' => $id ?: $conn->insert_id
        ];
    } else {
        throw new Exception('Database error: ' . $conn->error);
    }
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
    http_response_code(400); // Bad request
}

$conn->close();
echo json_encode($response);
?>